\version "2.16.0"

\paper {
 %#(set-paper-size "a4")
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.2\cm
  line-width = 19.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Pentru Tine, Doamne"
  subtitle = "(variantă)"
  composer =  \markup \center-column { "Chiril Popescu (1897 - 1992)" 
  	  	\small "Armonizare: prof. T. Sechei" }
  meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key g \major
  \time 4/4
  %\partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
}


womenWords = \lyrics {
  Pen -- tru Ti -- ne, Doam -- ne,
  flo -- ri -- le-n -- flo -- resc,
  pen -- tru Ti -- ne, noap -- tea,
  ste -- le stră -- lu -- cesc,
  pen -- tru Ti -- ne, noap -- tea,
  ste -- le stră -- lu -- cesc.
}  

menWords = \womenWords

sopMusic = \relative c'' {
  e,4.^\mp g8 b4 a g8([ a] fis[ g]) e4( g)
  b8( c b) a g4 a b2. b4\rest
  b4. b8 e4 d c8( b a c) b( a g fis)
  g4. a8 g4 a b2. b4\rest
  b4. b8 e4 d c8( b a c) b( a g fis)
  g4. a8 g4 fis e2. b'4\rest
  \bar ":|"
}

altMusic = \relative c'' {
  e,4. e8 g4 fis e( dis) e2
  g8( a g) fis e4 fis g2. b4\rest
  g4. g8 g4 g a8( g fis a) g( fis e dis)
  e4. e8 e4 fis g2. b4\rest
  g4. g8 g4 g a8( g fis a) g( fis e dis)
  e4. e8 e4 dis b2. b'4\rest	
}

tenorMusic = \relative c' {
  e,4. b'8 b4 c b( a) g2
  d'4. c8 b4 d d2. d,4\rest
  d'4. d8 c4 b d2 b
  b4. c8 b4 c d2. d,4\rest
  d'4. d8 c4 b d2 b
  b4. c8 b4 a g2. d4\rest	
}
	
bassMusic = \relative c {
  e4. e8 e4 e b( b) e2
  d4. d8 d4 d <g g,>2. d4\rest
  g4. g8 g4 g d2 e4( b)
  e4. e8 e4 d g2. d4\rest 
  g4. g8 g4 g d2 e4( b)
  e4. e8 b4 b e2. d4\rest
}

myScore = \new Score <<
  \new ChoirStaff <<
     \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
     >>

     \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
     >>
  >>
>>

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\book {

\score {
  \myScore
  \layout { }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

\markup {
    \large {
      \hspace #5.0
      "2."
      \column {
        "Pentru Tine, ploaia"
        "Picură şi cântă,"
        "Şi-n grădină cerne"
        "Bucurie sfântă."
      }
      \hspace #8.0
      "3."
      \column {
        "Pentru Tine, candeli"
        "La altare ard."
        "Tu, la zile sfinte,"
        "Miruieşti cu nard."
      }
      \hspace #6.0
      "4."
      \column {
        "Pe copiii, care,"
        "Osteniţi de joc,"
        "Pe iconostase,"
        "Ei pun busuioc."
      }
    }
  }  

  \markup {
    \large {
      \hspace #5.0
      \vspace #2.0
      "5."
      \column {
        "Lângă Tine, Doamne,"
        "Cei săraci se strâng,"
        "Ţie-Ţi cer iertare"
        "Ochii care plâng."
      }
      \hspace #5.0
      "6."
      \column {
        "Lângă Tine, Doamne,"
        "Plec genunchi, trudit,"
        "Numai Tu, Stăpâne,"
        "Nu m-ai părăsit."
      }
      \hspace #5.0
      "7."
      \column {
        "Dă-mi răbdarea pietrei"
        "Şi din cerul sfânt,"
        "Picură-mi, pe gene,"
        "Roua, să Te cânt."
      }
     }
  }
  \markup {
    \large {
      \hspace #38.0
      \vspace #2.0
      "8."
      \column {
        "Picură-mi în suflet"
        "Străjile uitării,"
        "Şi pe buze, pune-mi"
        "Străjile tăcerii."
      }
    } 
  }
  
}  
